classdef class_REVS_DCT_control
	%class_REVS_DCT_control
	%   Control class for REVS DCT transmission
	
	properties
		
		disengage_speed_radps;						% Speed where clutch will disengage when stopping [radps]
		disengage_max_gear			= Inf;			% Gear above which disengaging the clutch is not allowed [#]
		
		engage_pedal_norm           = 0.02;			% Accelerator pedal command to trigger clutch engagement [0-1]
		engage_speed_radps;							% Engagement speed profile [input speed @ 0 output speed, input speed @ match] [radps]
		
		
		engage_modulation_max_gear  = 2;			% Maximum gear where clutch modulation is permitted [#]
		engage_min_norm             = 0.01;			% Minimum Clutch Engagement - inital value when engaging [0-1]
		
		engage_Ki                   = 0.06;			% Clutch engagement integral gain
		engage_Kp                   = 0.002;        % Clutch engagement proportional gain
		
		
	end
	
	methods
		
		function obj = class_REVS_DCT_control(engine)
			
			if nargin >= 1
				
				obj.engage_speed_radps = interp1( [0,1], [min(engine.idle_speed_radps.table(:)) , max(engine.full_throttle_speed_radps) ], [0.04, 0.06] ) ;
				
				obj.disengage_speed_radps = interp1( [0,1], [min(engine.idle_speed_radps.table(:)) , max(engine.full_throttle_speed_radps) ], 0.02 ) ;
				
			end
			
		end
		
		
		function obj = set.engage_speed_radps(obj, val)
			if length( val) ~= 2
				error('Field engage_speed_radps requires a vecor of length 2')
			end
			obj.engage_speed_radps = val;
		end
		
		
		
		
	end
	
end

